var searchResultProvider = new SearchResultsProvider("ALR", "AutoLISP Reference Guide");
searchResultProvider.setTopicInfoList(["",{"title":"AutoLISP Functions",
"href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm",
"description":"The following is a catalog of the AutoLISP® functions available in AutoCAD®. The functions are listed alphabetically.",
"ancestors":[]},
{"title":"Operators",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"+ (add)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af7.htm",
"description":"Returns the sum of all numbers.",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"- (subtract)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af6.htm",
"description":"Subtracts the second and following numbers from the first and returns the difference",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"* (multiply)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af4.htm",
"description":"Returns the product of all numbers",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"/ (divide)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af2.htm",
"description":"Divides the first number by the product of the remaining numbers and returns the quotient",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"= (equal to)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af0.htm",
"description":"Compares arguments for numerical equality",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"/= (not equal to)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aee.htm",
"description":"Compares arguments for numerical inequality",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"< (less than)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aec.htm",
"description":"Returns T if each argument is numerically less than the argument to its right; otherwise nil",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"<= (less than or equal to)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aea.htm",
"description":"Returns T if each argument is numerically less than or equal to the argument to its right; otherwise returns nil",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"> (greater than)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ae8.htm",
"description":"Returns T if each argument is numerically greater than the argument to its right; otherwise returns nil",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":">= (greater than or equal to)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ae6.htm",
"description":"Returns T if each argument is numerically greater than or equal to the argument to its right; otherwise returns nil",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"~ (bitwise NOT)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ae4.htm",
"description":"Returns the bitwise NOT (1\'s complement) of the argument",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"1+ (increment)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ae2.htm",
"description":"Increments a number by 1",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"1- (decrement)",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ae0.htm",
"description":"Decrements a number by 1",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Operators","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6af8.htm"}]},
{"title":"A Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"abs",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6adc.htm",
"description":"Returns the absolute value of a number",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acad_colordlg",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ada.htm",
"description":"Displays the standard AutoCAD color selection dialog box",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acad_helpdlg",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ad8.htm",
"description":"Invokes the help facility (obsolete)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acad-pop-dbmod",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ad6.htm",
"description":"Restores the value of the DBMOD system variable to the value that was most recently stored with acad-push-dbmod",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acad-push-dbmod",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ad4.htm",
"description":"Stores the current value of the DBMOD system variable",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acad_strlsort",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ad2.htm",
"description":"Sorts a list of strings in alphabetical order",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acad_truecolorcli",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ad0.htm",
"description":"Prompts for colors at the command line",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acad_truecolordlg",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ace.htm",
"description":"Displays the AutoCAD color selection dialog box with tabs for index color, true color, and color books",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acdimenableupdate",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6acc.htm",
"description":"Controls the automatic updating of associative dimensions",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acet-layerp-mode",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aca.htm",
"description":"Queries and sets the LAYERPMODE setting",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acet-layerp-mark",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ac8.htm",
"description":"Places beginning and ending marks for Layer Previous recording",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acet-laytrans",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ac6.htm",
"description":"Translates drawing layers to standards defined in another drawing or standards file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acet-ms-to-ps",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ac4.htm",
"description":"Converts a real value from model space units to paper space units",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"acet-ps-to-ms",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ac2.htm",
"description":"Converts a real value from paper space units to model space units",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"action_tile",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ac0.htm",
"description":"Assigns an action to evaluate when the user selects the specified tile in a dialog box",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"add_list",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6abe.htm",
"description":"Adds or modifies a string in the currently active dialog box list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"alert",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6abc.htm",
"description":"Displays a dialog box containing an error or warning message",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"alloc",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aba.htm",
"description":"Sets the size of the segment to be used by the expand function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"and",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ab8.htm",
"description":"Returns the logical AND of the supplied arguments",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"angle",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ab6.htm",
"description":"Returns an angle in radians of a line defined by two endpoints",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"angtof",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ab4.htm",
"description":"Converts a string representing an angle into a real (floating-point) value in radians",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"angtos",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ab2.htm",
"description":"Converts an angular value in radians into a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"append",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ab0.htm",
"description":"Takes any number of lists and appends them together as one list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"apply",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aae.htm",
"description":"Passes a list of arguments to, and executes, a specified function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"arx",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aac.htm",
"description":"Returns a list of the currently loaded ObjectARX applications",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"arxload",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aaa.htm",
"description":"Loads an ObjectARX application",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"arxunload",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aa8.htm",
"description":"Unloads an ObjectARX application",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"ascii",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aa6.htm",
"description":"Returns the conversion of the first character of a string into its ASCII character code (an integer)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"assoc",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aa4.htm",
"description":"Searches an association list for an element and returns that association list entry",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"atan",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aa2.htm",
"description":"Returns the arctangent of a number in radians",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"atof",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6aa0.htm",
"description":"Converts a string into a real number",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"atoi",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a9e.htm",
"description":"Converts a string into an integer",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"atom",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a9c.htm",
"description":"Verifies that an item is an atom",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"atoms-family",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a9a.htm",
"description":"Returns a list of the currently defined symbols",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"autoarxload",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a98.htm",
"description":"Predefines command names to load an associated ObjectARX file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"autoload",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a96.htm",
"description":"Predefines command names to load an associated AutoLISP file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "A Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6ade.htm"}]},
{"title":"B Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a94.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"Boole",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a92.htm",
"description":"Serves as a general bitwise Boolean function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "B Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a94.htm"}]},
{"title":"boundp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8e.htm",
"description":"Verifies if a value is bound to a symbol",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "B Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a94.htm"}]},
{"title":"C Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"caddr",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8a.htm",
"description":"Returns the third element of a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"cadr",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a88.htm",
"description":"Returns the second element of a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"car",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a86.htm",
"description":"Returns the first element of a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"cdr",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a84.htm",
"description":"Returns a list containing all but the first element of the specified list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"chr",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a82.htm",
"description":"Converts an integer representing an ASCII character code into a single-character string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"client_data_tile",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a80.htm",
"description":"Associates application-managed data with a dialog box tile",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"close",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a7e.htm",
"description":"Closes an open file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"command",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a7c.htm",
"description":"Executes an AutoCAD command",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"cond",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a7a.htm",
"description":"Serves as the primary conditional function for AutoLISP",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"cons",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a78.htm",
"description":"Adds an element to the beginning of a list, or constructs a dotted list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"cos",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a76.htm",
"description":"Returns the cosine of an angle expressed in radians",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"cvunit",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a74.htm",
"description":"Converts a value from one unit of measurement to another",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "C Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a8c.htm"}]},
{"title":"D Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"defun",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a70.htm",
"description":"Defines a function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"defun-q",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a6e.htm",
"description":"Defines a function as a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"defun-q-list-ref",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a6c.htm",
"description":"Displays the list structure of a function defined with defun-q",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"defun-q-list-set",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a6a.htm",
"description":"Sets the value of a symbol to be a function defined by a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"dictadd",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a68.htm",
"description":"Adds a nongraphical object to the specified dictionary",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"dictnext",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a66.htm",
"description":"Finds the next item in a dictionary",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"dictremove",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a64.htm",
"description":"Removes an entry from the specified dictionary",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"dictrename",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a62.htm",
"description":"Renames a dictionary entry",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"dictsearch",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a60.htm",
"description":"Searches a dictionary for an item",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"dimx_tile",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a5e.htm",
"description":"Retrieves the width of a tile in dialog box units",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"dimy_tile",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a5c.htm",
"description":"Retrieves the height of a tile in dialog box units",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"distance",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a5a.htm",
"description":"Returns the 3D distance between two points",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"distof",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a58.htm",
"description":"Converts a string that represents a real (floating-point) value into a real value",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"done_dialog",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a56.htm",
"description":"Terminates a dialog box",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "D Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a72.htm"}]},
{"title":"E Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"end_image",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a52.htm",
"description":"Ends creation of the currently active dialog box image",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"end_list",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a50.htm",
"description":"Ends processing of the currently active dialog box list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"entdel",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a4e.htm",
"description":"Deletes objects (entities) or restores previously deleted objects",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"entget",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a4c.htm",
"description":"Retrieves an object\'s (entity\'s) definition data",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"entlast",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a4a.htm",
"description":"Returns the name of the last nondeleted main object (entity) in the drawing",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"entmake",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a48.htm",
"description":"Creates a new entity in the drawing",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"entmakex",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a45.htm",
"description":"Makes a new object or entity, gives it a handle and entity name (but does not assign an owner), and then returns the new entity name",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"entmod",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a43.htm",
"description":"Modifies the definition data of an object (entity)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"entnext",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a40.htm",
"description":"Returns the name of the next object (entity) in the drawing",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"entsel",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a3e.htm",
"description":"Prompts the user to select a single object (entity) by specifying a point",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"entupd",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a3c.htm",
"description":"Updates the screen image of an object (entity)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"eq",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a3a.htm",
"description":"Determines whether two expressions are identical",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"equal",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a38.htm",
"description":"Determines whether two expressions are equal",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"*error*",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a36.htm",
"description":"A user-definable error-handling function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"eval",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a34.htm",
"description":"Returns the result of evaluating an AutoLISP expression",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"exit",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a32.htm",
"description":"Forces the current application to quit",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"exp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a30.htm",
"description":"Returns the constant e (a real number) raised to a specified power (the natural antilog)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"expand",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a2e.htm",
"description":"Allocates additional memory for AutoLISP",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"expt",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a2b.htm",
"description":"Returns a number raised to a specified power",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "E Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a54.htm"}]},
{"title":"F Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a29.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"fill_image",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a27.htm",
"description":"Draws a filled rectangle in the currently active dialog box image tile",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "F Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a29.htm"}]},
{"title":"findfile",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a24.htm",
"description":"Searches the AutoCAD library path for the specified file or directory",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "F Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a29.htm"}]},
{"title":"fix",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a22.htm",
"description":"Returns the conversion of a real number into the nearest smaller integer",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "F Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a29.htm"}]},
{"title":"float",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a20.htm",
"description":"Returns the conversion of a number into a real number",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "F Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a29.htm"}]},
{"title":"foreach",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1e.htm",
"description":"Evaluates expressions for all members of a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "F Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a29.htm"}]},
{"title":"function",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1c.htm",
"description":"Tells the Visual LISP compiler to link and optimize an argument as if it were a built-in function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "F Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a29.htm"}]},
{"title":"G Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"gc",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a18.htm",
"description":"Forces a garbage collection, which frees up unused memory",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"gcd",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a16.htm",
"description":"Returns the greatest common denominator of two integers",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"get_attr",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a14.htm",
"description":"Retrieves the DCL value of a dialog box attribute",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"get_tile",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a12.htm",
"description":"Retrieves the current runtime value of a dialog box tile",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getangle",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a10.htm",
"description":"Pauses for user input of an angle, and returns that angle in radians",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getcfg",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a0e.htm",
"description":"Retrieves application data from the AppData section of the acad*.cfg file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getcname",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a0c.htm",
"description":"Retrieves the localized or English name of an AutoCAD command",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getcorner",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a0a.htm",
"description":"Pauses for user input of a rectangle\'s second corner",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getdist",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a08.htm",
"description":"Pauses for user input of a distance",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getenv",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a06.htm",
"description":"Returns the string value assigned to a system environment variable",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getfiled",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a04.htm",
"description":"Prompts the user for a file name with the standard AutoCAD file dialog box, and returns that file name",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getint",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a01.htm",
"description":"Pauses for user input of an integer, and returns that integer",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getkword",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69ff.htm",
"description":"Pauses for user input of a keyword, and returns that keyword",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getorient",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69fd.htm",
"description":"Pauses for user input of an angle, and returns that angle in radians",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getpoint",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69fb.htm",
"description":"Pauses for user input of a point, and returns that point",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getreal",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69f9.htm",
"description":"Pauses for user input of a real number, and returns that real number",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getstring",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69f7.htm",
"description":"Pauses for user input of a string, and returns that string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"getvar",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69f5.htm",
"description":"Retrieves the value of an AutoCAD system variable",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"graphscr",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69f3.htm",
"description":"Displays the AutoCAD graphics screen",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"grclear",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69f1.htm",
"description":"Clears the current viewport (obsolete function)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"grdraw",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69ef.htm",
"description":"Draws a vector between two points, in the current viewport",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"grread",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69ed.htm",
"description":"Reads values from any of the AutoCAD input devices",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"grtext",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69ea.htm",
"description":"Writes text to the status line or to screen menu areas",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"grvecs",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e8.htm",
"description":"Draws multiple vectors in the drawing area",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "G Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6a1a.htm"}]},
{"title":"H Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e6.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"handent",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e4.htm",
"description":"Returns an object (entity) name based on its handle",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "H Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e6.htm"}]},
{"title":"help",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e2.htm",
"description":"Invokes the Help facility",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "H Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e6.htm"}]},
{"title":"I Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e0.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"if",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69de.htm",
"description":"Conditionally evaluates expressions",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "I Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e0.htm"}]},
{"title":"initcommandversion",
"href":"./filesALR/WS1a9193826455f5ff1dbc298511635bea8755893.htm",
"description":"Forces the next command to run with the specified version.",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "I Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e0.htm"}]},
{"title":"initdia",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69dc.htm",
"description":"Forces the display of the next command\'s dialog box",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "I Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e0.htm"}]},
{"title":"initget",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69da.htm",
"description":"Establishes keywords for use by the next user-input function call",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "I Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e0.htm"}]},
{"title":"inters",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d4.htm",
"description":"Finds the intersection of two lines",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "I Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e0.htm"}]},
{"title":"itoa",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d2.htm",
"description":"Returns the conversion of an integer into a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "I Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69e0.htm"}]},
{"title":"L Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"lambda",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69ce.htm",
"description":"Defines an anonymous function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"last",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69cc.htm",
"description":"Returns the last element in a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layoutlist",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69ca.htm",
"description":"Returns a list of all paper space layouts in the current drawing",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-addlayers",
"href":"./filesALR/WS1a9193826455f5ffd9a7a610ecb0483d5-67f2.htm",
"description":"Adds or updates a series of layers to a layer state",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-compare",
"href":"./filesALR/WS73099cc142f487551ec84dc1111af5a7b7-7c9c.htm",
"description":"Compares a layerstate to the layers in the current drawing",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-delete",
"href":"./filesALR/WS1a9193826455f5ffd9a7a610ecb0483d5-67df.htm",
"description":"Deletes a layer state",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-export",
"href":"./filesALR/WS1a9193826455f5ffd9a7a610ecb0483d5-67bd.htm",
"description":"Exports a layer state to a specified file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-getlastrestored",
"href":"./filesALR/WS73099cc142f487551ec84dc1111af5a7b7-7c8f.htm",
"description":"Returns the name of the last restored layer state in the current drawing",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-getlayers",
"href":"./filesALR/WS1a9193826455f5ffd9a7a610ecb0483d5-67ca.htm",
"description":"Returns the layers saved in a layer state",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-getnames",
"href":"./filesALR/WS73099cc142f487551ec84dc1111af5a7b7-7c8a.htm",
"description":"Returns a list of the layer state names",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-has",
"href":"./filesALR/WS1a9193826455f5ffd9a7a610ecb0483d5-67e5.htm",
"description":"Checks if a layer state is present",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-import",
"href":"./filesALR/WS1a9193826455f5ffd9a7a610ecb0483d5-67c3.htm",
"description":"Imports a layer state from a specified file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-importfromdb",
"href":"./filesALR/WS1a9193826455f5ff1b508da11142adfd67-7f9c.htm",
"description":"Imports a layer state from a specified drawing file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-removelayers",
"href":"./filesALR/WS1a9193826455f5ff1b508da11142adfd67-7f94.htm",
"description":"Removes a list of layers from a layer state",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-rename",
"href":"./filesALR/WS1a9193826455f5ffd9a7a610ecb0483d5-67d9.htm",
"description":"Renames a layer state",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-restore",
"href":"./filesALR/WS1a9193826455f5ffd9a7a610ecb0483d5-67b6.htm",
"description":"Restores a layer state into the current drawing",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"layerstate-save",
"href":"./filesALR/WS1a9193826455f5ffd9a7a610ecb0483d5-67d2.htm",
"description":"Saves a layer state in the current drawing",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"length",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69c8.htm",
"description":"Returns an integer indicating the number of elements in a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"list",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69c6.htm",
"description":"Takes any number of expressions and combines them into one list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"listp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69c4.htm",
"description":"Verifies that an item is a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"load",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69c2.htm",
"description":"Evaluates the AutoLISP expressions in a file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"load_dialog",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69bf.htm",
"description":"Loads a DCL file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"log",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69bd.htm",
"description":"Returns the natural log of a number as a real number",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"logand",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69bb.htm",
"description":"Returns the result of the logical bitwise AND of a list of integers",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"logior",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b9.htm",
"description":"Returns the result of the logical bitwise inclusive OR of a list of integers",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"lsh",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b7.htm",
"description":"Returns the logical bitwise shift of an integer by a specified number of bits",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "L Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69d0.htm"}]},
{"title":"M Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b5.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"mapcar",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b3.htm",
"description":"Returns a list that is the result of executing a function with a list (or lists) supplied as arguments to the function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "M Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b5.htm"}]},
{"title":"max",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b1.htm",
"description":"Returns the largest of the numbers given",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "M Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b5.htm"}]},
{"title":"mem",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69af.htm",
"description":"Displays the current state of the AutoLISP memory",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "M Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b5.htm"}]},
{"title":"member",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69ad.htm",
"description":"Searches a list for an occurrence of an expression and returns the remainder of the list, starting with the first occurrence of the expression",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "M Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b5.htm"}]},
{"title":"menucmd",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69ab.htm",
"description":"Issues menu commands, or sets and retrieves menu item status",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "M Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b5.htm"}]},
{"title":"menugroup",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a9.htm",
"description":"Verifies that a menugroup is loaded",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "M Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b5.htm"}]},
{"title":"min",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a7.htm",
"description":"Returns the smallest of the numbers given",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "M Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b5.htm"}]},
{"title":"minusp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a5.htm",
"description":"Verifies that a number is negative",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "M Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b5.htm"}]},
{"title":"mode_tile",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a3.htm",
"description":"Sets the mode of a dialog box tile",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "M Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69b5.htm"}]},
{"title":"N Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a1.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"namedobjdict",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-699f.htm",
"description":"Returns the entity name of the current drawing\'s named object dictionary, which is the root of all nongraphical objects in the drawing",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "N Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a1.htm"}]},
{"title":"nentsel",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-699d.htm",
"description":"Prompts the user to select an object (entity) by specifying a point, and provides access to the definition data contained within a complex object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "N Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a1.htm"}]},
{"title":"nentselp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-699b.htm",
"description":"Provides similar functionality to that of the nentsel function without the need for user input",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "N Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a1.htm"}]},
{"title":"new_dialog",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6999.htm",
"description":"Begins a new dialog box and displays it, and can also specify a default action",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "N Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a1.htm"}]},
{"title":"not",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6997.htm",
"description":"Verifies that an item evaluates to nil",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "N Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a1.htm"}]},
{"title":"nth",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6995.htm",
"description":"Returns the nth element of a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "N Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a1.htm"}]},
{"title":"null",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6993.htm",
"description":"Verifies that an item is bound to nil",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "N Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a1.htm"}]},
{"title":"numberp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6991.htm",
"description":"Verifies that an item is a real number or an integer",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "N Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-69a1.htm"}]},
{"title":"O Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-698f.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"open",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-698d.htm",
"description":"Opens a file for access by the AutoLISP I/O functions",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "O Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-698f.htm"}]},
{"title":"or",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-698b.htm",
"description":"Returns the logical OR of a list of expressions",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "O Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-698f.htm"}]},
{"title":"osnap",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6989.htm",
"description":"Returns a 3D point that is the result of applying an Object Snap mode to a specified point",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "O Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-698f.htm"}]},
{"title":"P Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6987.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"polar",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6985.htm",
"description":"Returns the UCS 3D point at a specified angle and distance from a point",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "P Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6987.htm"}]},
{"title":"prin1",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6983.htm",
"description":"Prints an expression to the command line or writes an expression to an open file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "P Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6987.htm"}]},
{"title":"princ",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6980.htm",
"description":"Prints an expression to the command line, or writes an expression to an open file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "P Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6987.htm"}]},
{"title":"print",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-697e.htm",
"description":"Prints an expression to the command line, or writes an expression to an open file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "P Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6987.htm"}]},
{"title":"progn",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-697c.htm",
"description":"Evaluates each expression sequentially and returns the value of the last expression",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "P Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6987.htm"}]},
{"title":"prompt",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-697a.htm",
"description":"Displays a string on your screen\'s prompt area",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "P Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6987.htm"}]},
{"title":"Q Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6978.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"quit",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6976.htm",
"description":"Forces the current application to quit",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Q Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6978.htm"}]},
{"title":"quote",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6974.htm",
"description":"Returns an expression without evaluating it",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Q Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6978.htm"}]},
{"title":"R Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6972.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"read",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6970.htm",
"description":"Returns the first list or atom obtained from a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "R Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6972.htm"}]},
{"title":"read-char",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-696e.htm",
"description":"Returns the decimal ASCII code representing the character read from the keyboard input buffer or from an open file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "R Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6972.htm"}]},
{"title":"read-line",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-696c.htm",
"description":"Reads a string from the keyboard or from an open file, until an end-of-line marker is encountered",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "R Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6972.htm"}]},
{"title":"redraw",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-696a.htm",
"description":"Redraws the current viewport or a specified object (entity) in the current viewport",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "R Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6972.htm"}]},
{"title":"regapp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6968.htm",
"description":"Registers an application name with the current AutoCAD drawing in preparation for using extended object data",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "R Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6972.htm"}]},
{"title":"rem",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6966.htm",
"description":"Divides the first number by the second, and returns the remainder",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "R Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6972.htm"}]},
{"title":"repeat",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6964.htm",
"description":"Evaluates each expression a specified number of times, and returns the value of the last expression",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "R Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6972.htm"}]},
{"title":"reverse",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6962.htm",
"description":"Returns a copy of a list with its elements reversed",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "R Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6972.htm"}]},
{"title":"rtos",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6960.htm",
"description":"Converts a number into a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "R Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6972.htm"}]},
{"title":"S Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"set",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695c.htm",
"description":"Sets the value of a quoted symbol name to an expression",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"set_tile",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695a.htm",
"description":"Sets the value of a dialog box tile",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"setcfg",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6958.htm",
"description":"Writes application data to the AppData section of the acad*.cfg file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"setenv",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6956.htm",
"description":"Sets a system environment variable to a specified value",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"setfunhelp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6954.htm",
"description":"Registers a user-defined command with the Help facility so the appropriate Help file and topic are called when the user requests help on that command",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"setq",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6952.htm",
"description":"Sets the value of a symbol or symbols to associated expressions",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"setvar",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6950.htm",
"description":"Sets an AutoCAD system variable to a specified value",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"setview",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-694e.htm",
"description":"Establishes a view for a specified viewport",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"sin",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-694c.htm",
"description":"Returns the sine of an angle as a real number expressed in radians",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"slide_image",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-694a.htm",
"description":"Displays an AutoCAD slide in the currently active dialog box image tile",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"snvalid",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6948.htm",
"description":"Checks the symbol table name for valid characters",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"sqrt",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6944.htm",
"description":"Returns the square root of a number as a real number",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"ssadd",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6942.htm",
"description":"Adds an object (entity) to a selection set, or creates a new selection set",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"ssdel",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6940.htm",
"description":"Deletes an object (entity) from a selection set",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"ssget",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-693e.htm",
"description":"Creates a selection set from the selected object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"ssgetfirst",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-693b.htm",
"description":"Determines which objects are selected and gripped",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"sslength",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6939.htm",
"description":"Returns an integer containing the number of objects (entities) in a selection set",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"ssmemb",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6937.htm",
"description":"Tests whether an object (entity) is a member of a selection set",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"ssname",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6935.htm",
"description":"Returns the object (entity) name of the indexed element of a selection set",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"ssnamex",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6933.htm",
"description":"Retrieves information about how a selection set was created",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"sssetfirst",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-692f.htm",
"description":"Sets which objects are selected and gripped",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"startapp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-692d.htm",
"description":"Starts a Windows application",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"start_dialog",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-692b.htm",
"description":"Displays a dialog box and begins accepting user input",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"start_image",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6929.htm",
"description":"Starts the creation of an image in the dialog box tile",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"start_list",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6927.htm",
"description":"Starts the processing of a list in the list box or in the pop-up list dialog box tile",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"strcase",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6925.htm",
"description":"Returns a string where all alphabetic characters have been converted to uppercase or lowercase",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"strcat",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6923.htm",
"description":"Returns a string that is the concatenation of multiple strings",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"strlen",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6921.htm",
"description":"Returns an integer that is the number of characters in a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"subst",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691f.htm",
"description":"Searches a list for an old item and returns a copy of the list with a new item substituted in place of every occurrence of the old item",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"substr",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691d.htm",
"description":"Returns a substring of a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "S Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-695e.htm"}]},
{"title":"T Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"tablet",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6919.htm",
"description":"Retrieves and sets digitizer (tablet) calibrations",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"tblnext",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6917.htm",
"description":"Finds the next item in a symbol table",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"tblobjname",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6915.htm",
"description":"Returns the entity name of a specified symbol table entry",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"tblsearch",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6913.htm",
"description":"Searches a symbol table for a symbol name",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"term_dialog",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6911.htm",
"description":"Terminates all current dialog boxes as if the user had canceled each of them",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"terpri",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-690f.htm",
"description":"Prints a newline to the command line",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"textbox",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-690d.htm",
"description":"Measures a specified text object, and returns the diagonal coordinates of a box that encloses the text",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"textpage",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-690b.htm",
"description":"Switches focus from the drawing area to the text screen",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"textscr",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6909.htm",
"description":"Switches focus from the drawing area to the text screen (like the AutoCAD F2 function key)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"trace",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6907.htm",
"description":"Aids in AutoLISP debugging",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"trans",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6905.htm",
"description":"Translates a point (or a displacement) from one coordinate system to another",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"type",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6902.htm",
"description":"Returns the type of a specified item",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "T Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-691b.htm"}]},
{"title":"U Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68ff.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"unload_dialog",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68fd.htm",
"description":"Unloads a DCL file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "U Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68ff.htm"}]},
{"title":"untrace",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68fb.htm",
"description":"Clears the trace flag for the specified functions",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "U Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68ff.htm"}]},
{"title":"V Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"vector_image",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f7.htm",
"description":"Draws a vector in the currently active dialog box image",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"ver",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f4.htm",
"description":"Returns a string that contains the current AutoLISP version number",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-acad-defun",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f2.htm",
"description":"Defines an AutoLISP function symbol as an external subroutine",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-acad-undefun",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f0.htm",
"description":"Undefines an AutoLISP function symbol so it is no longer available to ObjectARX applications",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-arx-import",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68ee.htm",
"description":"Imports ObjectARX/ADSRX functions into a separate-namespace VLX",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-bb-ref",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68eb.htm",
"description":"Returns the value of a variable from the blackboard namespace",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-bb-set",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68e9.htm",
"description":"Sets a variable in the blackboard namespace",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-catch-all-apply",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68e7.htm",
"description":"Passes a list of arguments to a specified function and traps any exceptions",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-catch-all-error-message",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68e5.htm",
"description":"Returns a string from an error object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-catch-all-error-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68e3.htm",
"description":"Determines whether an argument is an error object returned from vl-catch-all-apply",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-cmdf",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68e1.htm",
"description":"Executes an AutoCAD command",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-consp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68df.htm",
"description":"Determines whether or not a list is nil",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-directory-files",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68dd.htm",
"description":"Lists all files in a given directory",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-doc-export",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68db.htm",
"description":"Makes a function available to the current document",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-doc-import",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68d9.htm",
"description":"Imports a previously exported function into a VLX namespace",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-doc-ref",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68d7.htm",
"description":"Retrieves the value of a variable from the current document\'s namespace",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-doc-set",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68d5.htm",
"description":"Sets the value of a variable in the current document\'s namespace",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-every",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68d3.htm",
"description":"Checks whether the predicate is true for every element combination",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-exit-with-error",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68d0.htm",
"description":"Passes control from a VLX error handler to the *error* function of the calling namespace",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-exit-with-value",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68ce.htm",
"description":"Returns a value to the function that invoked the VLX from another namespace",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-file-copy",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68cc.htm",
"description":"Copies or appends the contents of one file to another file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-file-delete",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68c9.htm",
"description":"Deletes a file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-file-directory-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68c7.htm",
"description":"Determines if a file name refers to a directory",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-file-rename",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68c5.htm",
"description":"Renames a file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-file-size",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68c3.htm",
"description":"Determines the size of a file, in bytes",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-file-systime",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68c1.htm",
"description":"Returns last modification time of the specified file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-filename-base",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68be.htm",
"description":"Returns the name of a file, after stripping out the directory path and extension",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-filename-directory",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68bc.htm",
"description":"Returns the directory path of a file, after stripping out the name and extension",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-filename-extension",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68ba.htm",
"description":"Returns the extension from a file name, after stripping out the rest of the name",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-filename-mktemp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68b8.htm",
"description":"Calculates a unique file name to be used for a temporary file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-get-resource",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68b5.htm",
"description":"Returns the text stored in a .txt file packaged in a VLX",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-list*",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68b3.htm",
"description":"Constructs and returns a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-list->string",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68b0.htm",
"description":"Combines the characters associated with a list of integers into a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-list-exported-functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68ae.htm",
"description":"Lists exported functions",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-list-length",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68ac.htm",
"description":"Calculates list length of a true list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-list-loaded-vlx",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68aa.htm",
"description":"Returns a list of all separate-namespace VLX files associated with the current document",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-load-all",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68a8.htm",
"description":"Loads a file into all open AutoCAD documents, and into any document subsequently opened during the current AutoCAD session",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-load-com",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68a6.htm",
"description":"Loads Visual LISP extensions to AutoLISP",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-load-reactors",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68a4.htm",
"description":"Loads reactor support functions",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-mkdir",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68a2.htm",
"description":"Creates a directory",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-member-if",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68a0.htm",
"description":"Determines if the predicate is true for one of the list members",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-member-if-not",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-689d.htm",
"description":"Determines if the predicate is nil for one of the list members",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-position",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-689a.htm",
"description":"Returns the index of the specified list item",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-prin1-to-string",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6898.htm",
"description":"Returns the string representation of LISP data as if it were output by the prin1 function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-princ-to-string",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6896.htm",
"description":"Returns the string representation of LISP data as if it were output by the princ function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-propagate",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6894.htm",
"description":"Copies the value of a variable into all open document namespaces (and sets its value in any subsequent drawings opened during the current AutoCAD session)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-registry-delete",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6892.htm",
"description":"Deletes the specified key or value from the Windows registry",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-registry-descendents",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6890.htm",
"description":"Returns a list of subkeys or value names for the specified registry key",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-registry-read",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-688e.htm",
"description":"Returns data stored in the Windows registry for the specified key/value pair",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-registry-write",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-688c.htm",
"description":"Creates a key in the Windows registry",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-remove",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-688a.htm",
"description":"Removes elements from a list",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-remove-if",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6888.htm",
"description":"Returns all elements of the supplied list that fail the test function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-remove-if-not",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6885.htm",
"description":"Returns all elements of the supplied list that pass the test function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-some",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6882.htm",
"description":"Checks whether the predicate is not nil for one element combination",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-sort",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-687f.htm",
"description":"Sorts the elements in a list according to a given compare function",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-sort-i",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-687c.htm",
"description":"Sorts the elements in a list according to a given compare function, and returns the element index numbers",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-string->list",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6879.htm",
"description":"Converts a string into a list of character codes",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-string-elt",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6877.htm",
"description":"Returns the ASCII representation of the character at a specified position in a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-string-left-trim",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6875.htm",
"description":"Removes the specified characters from the beginning of a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-string-mismatch",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6873.htm",
"description":"Returns the length of the longest common prefix for two strings, starting at specified positions",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-string-position",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6871.htm",
"description":"Looks for a character with the specified ASCII code in a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-string-right-trim",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-686f.htm",
"description":"Removes the specified characters from the end of a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-string-search",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-686d.htm",
"description":"Searches for the specified pattern in a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-string-subst",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-686b.htm",
"description":"Substitutes one string for another, within a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-string-translate",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6869.htm",
"description":"Replaces characters in a string with a specified set of characters",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-string-trim",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6867.htm",
"description":"Removes the specified characters from the beginning and end of a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-symbol-name",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6865.htm",
"description":"Returns a string containing the name of a symbol",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-symbol-value",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6863.htm",
"description":"Returns the current value bound to a symbol",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-symbolp",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6861.htm",
"description":"Identifies whether or not a specified object is a symbol",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-unload-vlx",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-685f.htm",
"description":"Unload a VLX application that is loaded in its own namespace",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-vbaload",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-685d.htm",
"description":"Loads a VBA project",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-vbarun",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-685b.htm",
"description":"Runs a VBA macro",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vl-vlx-loaded-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6859.htm",
"description":"Determines whether a separate-namespace VLX is currently loaded",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-3D-point",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6857.htm",
"description":"Creates ActiveX-compatible (variant) 3D point structure",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-add-cmd",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6855.htm",
"description":"Adds commands to the AutoCAD built-in command set",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-create-object",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6853.htm",
"description":"Creates a new instance of an application object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getArea",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6851.htm",
"description":"Returns the area inside the curve",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getClosestPointTo",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-684e.htm",
"description":"Returns the point (in WCS) on a curve that is nearest to the specified point",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getClosestPointToProjection",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-684b.htm",
"description":"Returns the closest point (in WCS) on a curve after projecting the curve onto a plane",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getDistAtParam",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6849.htm",
"description":"Returns the length of the curve\'s segment from the curve\'s beginning to the specified parameter",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getDistAtPoint",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6846.htm",
"description":"Returns the length of the curve\'s segment between the curve\'s start point and the specified point",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getEndParam",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6844.htm",
"description":"Returns the parameter of the endpoint of the curve",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getEndPoint",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6842.htm",
"description":"Returns the endpoint (in WCS) of the curve",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getFirstDeriv",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6840.htm",
"description":"Returns the first derivative (in WCS) of a curve at the specified location",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getParamAtDist",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-683e.htm",
"description":"Returns the parameter of a curve at the specified distance from the beginning of the curve",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getParamAtPoint",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-683c.htm",
"description":"Returns the parameter of the curve at the point",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getPointAtDist",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-683a.htm",
"description":"Returns the point (in WCS) along a curve at the distance specified by the user",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getPointAtParam",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6838.htm",
"description":"Returns the point at the specified parameter value along a curve",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getSecondDeriv",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6836.htm",
"description":"Returns the second derivative (in WCS) of a curve at the specified location",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getStartParam",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6834.htm",
"description":"Returns the start parameter on the curve",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-getStartPoint",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6832.htm",
"description":"Returns the start point (in WCS) of the curve",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-isClosed",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6830.htm",
"description":"Determines if the specified curve is closed (that is, the start point is the same as the endpoint)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-isPeriodic",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-682e.htm",
"description":"Determines if the specified curve has an infinite range in both directions and there is a period value dT, such that a point on the curve at (u + dT) = point on curve (u), for any parameter u",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-curve-isPlanar",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-682c.htm",
"description":"Determines if there is a plane that contains the curve",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-dump-object",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-682a.htm",
"description":"Lists an object\'s properties, and optionally, the methods that apply to the object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-ename->vla-object",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6828.htm",
"description":"Transforms an entity to a VLA-object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-erased-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6826.htm",
"description":"Determines whether an object was erased",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-for",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6824.htm",
"description":"Iterates through a collection of objects, evaluating each expression",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-get-acad-object",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6822.htm",
"description":"Retrieves the top level AutoCAD application object for the current AutoCAD session",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-get-object",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6820.htm",
"description":"Returns a running instance of an application object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-get-or-create-object",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-681e.htm",
"description":"Returns a running instance of an application object, or creates a new instance if the application is not currently running",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-get-property",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-681c.htm",
"description":"Retrieves a VLA-object\'s property",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-import-type-library",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-681a.htm",
"description":"Imports information from a type library",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-invoke-method",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6816.htm",
"description":"Calls the specified ActiveX method",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-ldata-delete",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6814.htm",
"description":"Erases LISP data from a drawing dictionary",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-ldata-get",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6812.htm",
"description":"Retrieves LISP data from a drawing dictionary or an object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-ldata-list",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-680e.htm",
"description":"Lists LISP data in a drawing dictionary",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-ldata-put",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-680c.htm",
"description":"Stores LISP data in a drawing dictionary or an object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-ldata-test",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-680a.htm",
"description":"Determines if data can be saved over a session boundary",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-make-safearray",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6808.htm",
"description":"Creates a safearray",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-make-variant",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6806.htm",
"description":"Creates a variant data type",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-map-collection",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6804.htm",
"description":"Applies a function to all objects in a collection",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-method-applicable-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6802.htm",
"description":"Determines if an object supports a particular method",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-object-released-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6800.htm",
"description":"Determines if an object has been released",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-product-key",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67fe.htm",
"description":"Returns the AutoCAD Windows registry path",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-property-available-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67fc.htm",
"description":"Determines if an object has a specified property",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-put-property",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67fa.htm",
"description":"Sets the property of an ActiveX object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-read-enabled-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67f8.htm",
"description":"Determines if an object can be read",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-release-object",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67f6.htm",
"description":"Releases a drawing object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-remove-cmd",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67f4.htm",
"description":"Removes a single command or a command group",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-safearray-fill",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67f2.htm",
"description":"Stores data in the elements of a safearray",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-safearray-get-dim",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67f0.htm",
"description":"Returns the number of dimensions in a safearray object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-safearray-get-element",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67ee.htm",
"description":"Returns an element from an array",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-safearray-get-l-bound",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67ec.htm",
"description":"Returns the lower boundary (starting index) of a dimension of an array",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-safearray-get-u-bound",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67ea.htm",
"description":"Returns the upper boundary (end index) of a dimension of an array",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-safearray-put-element",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67e8.htm",
"description":"Adds an element to an array",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-safearray-type",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67e6.htm",
"description":"Returns the data type of a safearray",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-safearray->list",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67e4.htm",
"description":"Returns the elements of a safearray in list form",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-tmatrix",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67e2.htm",
"description":"Returns a suitable representation for a 4 x 4 transformation matrix to be used in VLA methods",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-typeinfo-available-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67e0.htm",
"description":"Determines whether TypeLib information is present for the specified type of object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-variant-change-type",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67de.htm",
"description":"Returns the value of a variant after changing it from one data type to another",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-variant-type",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67dc.htm",
"description":"Determines the data type of a variant",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-variant-value",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67da.htm",
"description":"Returns the value of a variant",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-vla-object->ename",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67d8.htm",
"description":"Transforms a VLA-object to an AutoLISP entity",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlax-write-enabled-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67d6.htm",
"description":"Determines if an AutoCAD drawing object can be modified",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlisp-compile",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67d4.htm",
"description":"Compiles AutoLISP source code into a FAS file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-acdb-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67d2.htm",
"description":"Constructs a reactor object that notifies when an object is added to, modified in, or erased from a drawing database",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-add",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67cf.htm",
"description":"Enables a disabled reactor object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-added-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67cd.htm",
"description":"Tests to determine if a reactor object is enabled",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-beep-reaction",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67cb.htm",
"description":"Produces a beep sound",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-command-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67c9.htm",
"description":"Constructs an editor reactor that notifies of a command event",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-current-reaction-name",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67c6.htm",
"description":"Returns the name (symbol) of the current event, if called from within a reactor\'s callback",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-data",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67c4.htm",
"description":"Returns application-specific data associated with a reactor",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-data-set",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67c2.htm",
"description":"Overwrites application-specific data associated with a reactor",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-deepclone-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67c0.htm",
"description":"Constructs an editor reactor object that notifies of a deep clone event",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-docmanager-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67bc.htm",
"description":"Constructs a reactor object that notifies of events relating to drawing documents",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-dwg-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67b8.htm",
"description":"Constructs an editor reactor object that notifies of a drawing event (for example, opening or closing a drawing file)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-dxf-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67b4.htm",
"description":"Constructs an editor reactor object that notifies of an event related to reading or writing a DXF file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-editor-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67b0.htm",
"description":"Constructs an editor reactor object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-insert-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67ac.htm",
"description":"Constructs an editor reactor object that notifies of an event related to block insertion",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-linker-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67a8.htm",
"description":"Constructs a reactor object that notifies your application every time an ObjectARX application is loaded or unloaded",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-lisp-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67a5.htm",
"description":"Constructs an editor reactor object that notifies of a LISP event",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-miscellaneous-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-67a1.htm",
"description":"Constructs an editor reactor object that does not fall under any other editor reactor types",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-mouse-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-679d.htm",
"description":"Constructs an editor reactor object that notifies of a mouse event (for example, a double-click)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-notification",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6799.htm",
"description":"Determines whether or not a reactor will fire if its associated namespace is not active",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-object-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6797.htm",
"description":"Constructs a drawing object reactor object",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-owner-add",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6793.htm",
"description":"Adds an object to the list of owners of an object reactor",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-owner-remove",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6791.htm",
"description":"Removes an object from the list of owners of an object reactor",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-owners",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-678f.htm",
"description":"Returns the list of owners of an object reactor",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-pers",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-678d.htm",
"description":"Makes a reactor persistent",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-pers-list",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-678b.htm",
"description":"Returns a list of persistent reactors in the current drawing document",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-pers-p",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6789.htm",
"description":"Determines whether a reactor is persistent",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-pers-release",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6787.htm",
"description":"Makes a reactor transient",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-reaction-name",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6785.htm",
"description":"Returns a list of all possible callback conditions for this reactor type",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-reaction-set",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6783.htm",
"description":"Adds or replaces a callback function in a reactor",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-reactions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6781.htm",
"description":"Returns a list of pairs (event-name . callback_function) for the reactor",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-reactors",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-677f.htm",
"description":"Returns a list of existing reactors",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-remove",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-677d.htm",
"description":"Disables a reactor",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-remove-all",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-677b.htm",
"description":"Disables all reactors of the specified type",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-set-notification",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6779.htm",
"description":"Defines whether a reactor\'s callback function will execute if its associated namespace is not active",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-sysvar-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6777.htm",
"description":"Constructs an editor reactor object that notifies of a change to a system variable",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-toolbar-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6773.htm",
"description":"Constructs an editor reactor object that notifies of a change to the bitmaps in a toolbar",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-trace-reaction",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-676f.htm",
"description":"A predefined callback function that prints one or more callback arguments in the Trace window",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-type",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-676d.htm",
"description":"Returns a symbol representing the reactor type",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-types",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-676a.htm",
"description":"Returns a list of all reactor types",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-undo-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6768.htm",
"description":"Constructs an editor reactor object that notifies of an undo event",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-wblock-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6764.htm",
"description":"Constructs an editor reactor object that notifies of an event related to writing a block",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-window-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6760.htm",
"description":"Constructs an editor reactor object that notifies of an event related to moving or sizing an AutoCAD window",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vlr-xref-reactor",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-675c.htm",
"description":"Constructs an editor reactor object that notifies of an event related to attaching or modifying XREFs",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"vports",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6758.htm",
"description":"Returns a list of viewport descriptors for the current viewport configuration",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "V Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-68f9.htm"}]},
{"title":"W Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6756.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"wcmatch",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6754.htm",
"description":"Performs a wild-card pattern match on a string",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "W Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6756.htm"}]},
{"title":"while",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6750.htm",
"description":"Evaluates a test expression, and if it is not nil, evaluates other expressions; repeats this process until the test expression evaluates to nil",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "W Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6756.htm"}]},
{"title":"write-char",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-674e.htm",
"description":"Writes one character to the screen or to an open file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "W Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6756.htm"}]},
{"title":"write-line",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-674c.htm",
"description":"Writes a string to the screen or to an open file",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "W Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6756.htm"}]},
{"title":"X Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-674a.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"xdroom",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6748.htm",
"description":"Returns the amount of extended data (xdata) space that is available for an object (entity)",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "X Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-674a.htm"}]},
{"title":"xdsize",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6746.htm",
"description":"Returns the size (in bytes) that a list occupies when it is linked to an object (entity) as extended data",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "X Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-674a.htm"}]},
{"title":"Z Functions",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6744.htm",
"description":"",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"}]},
{"title":"zerop",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6742.htm",
"description":"Verifies that a number evaluates to zero",
"ancestors":[{"title": "AutoLISP Functions","href":"./filesALR/WSfacf1429558a55de1a7524c1004e616f8b-5913.htm"},{"title": "Z Functions","href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6744.htm"}]},
{"title":"Externally Defined Commands",
"href":"./filesALR/WSfacf1429558a55de185c428100849a0ab7-54ef.htm",
"description":"AutoCAD® commands defined by ObjectARX® or AutoLISP® applications are called externally defined. AutoLISP applications may need to access externally defined commands differently from the way they access built-in AutoLISP functions. Many externally defined commands have their own programming interfaces that allow AutoLISP applications to take advantage of their functionality.",
"ancestors":[]},
{"title":"3dsin",
"href":"./filesALR/WS73099cc142f487551face55114134b88b1-7220.htm",
"description":"",
"ancestors":[{"title": "Externally Defined Commands","href":"./filesALR/WSfacf1429558a55de185c428100849a0ab7-54ef.htm"}]},
{"title":"align",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6740.htm",
"description":"",
"ancestors":[{"title": "Externally Defined Commands","href":"./filesALR/WSfacf1429558a55de185c428100849a0ab7-54ef.htm"}]},
{"title":"cal",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-673e.htm",
"description":"",
"ancestors":[{"title": "Externally Defined Commands","href":"./filesALR/WSfacf1429558a55de185c428100849a0ab7-54ef.htm"}]},
{"title":"mirror3d",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-673c.htm",
"description":"",
"ancestors":[{"title": "Externally Defined Commands","href":"./filesALR/WSfacf1429558a55de185c428100849a0ab7-54ef.htm"}]},
{"title":"rotate3d",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-673a.htm",
"description":"",
"ancestors":[{"title": "Externally Defined Commands","href":"./filesALR/WSfacf1429558a55de185c428100849a0ab7-54ef.htm"}]},
{"title":"solprof",
"href":"./filesALR/WS1a9193826455f5ff1a32d8d10ebc6b7ccc-6738.htm",
"description":"",
"ancestors":[{"title": "Externally Defined Commands","href":"./filesALR/WSfacf1429558a55de185c428100849a0ab7-54ef.htm"}]},
]);
top.HlpSys.search.data.registerSearchProvider(searchResultProvider);
// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEGDo
// SIG // uTlvW+M7uHl8RJntQbugggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQsZng
// SIG // LqxxXYXDE+OggoVWyjBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGAjZIw7U6K6n2/eaf+1koz
// SIG // 3v9AKyBvMxRTu4PPtxhLq6Mm/UcAkPmxgoJRF4/A9YVL
// SIG // a5m4gl3X01Wm04quNOCPoDO886ujQc8F2eHKY3NjUVqm
// SIG // pU/S6YsRuz6hT7Ng3Yq1ZUWoMVByjrxXhDQfPTbSAC6n
// SIG // YhzBQdSL3SpocGqaykU=
// SIG // End signature block
